/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import net.jodah.failsafe.AsyncFailsafe;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Listeners;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.SyncFailsafe;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.CancelableCompletableFuture;
import org.zalando.riptide.Plugin;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.failsafe.RetryListener;

@API(status=API.Status.STABLE)
public final class FailsafePlugin
implements Plugin {
    private static final RetryPolicy NEVER = new RetryPolicy().withMaxRetries(0);
    private final ScheduledExecutorService scheduler;
    private final RetryPolicy retryPolicy;
    private final CircuitBreaker circuitBreaker;
    private final RetryListener listener;

    public FailsafePlugin(ScheduledExecutorService scheduler) {
        this(scheduler, NEVER, new CircuitBreaker(), RetryListener.DEFAULT);
    }

    @API(status=API.Status.INTERNAL)
    FailsafePlugin(ScheduledExecutorService scheduler, RetryPolicy retryPolicy, CircuitBreaker circuitBreaker, RetryListener listener) {
        this.scheduler = scheduler;
        this.retryPolicy = retryPolicy;
        this.circuitBreaker = circuitBreaker;
        this.listener = listener;
    }

    public FailsafePlugin withRetryPolicy(RetryPolicy retryPolicy) {
        return new FailsafePlugin(this.scheduler, retryPolicy, this.circuitBreaker, this.listener);
    }

    public FailsafePlugin withCircuitBreaker(CircuitBreaker circuitBreaker) {
        return new FailsafePlugin(this.scheduler, this.retryPolicy, circuitBreaker, this.listener);
    }

    public FailsafePlugin withListener(RetryListener listener) {
        return new FailsafePlugin(this.scheduler, this.retryPolicy, this.circuitBreaker, listener);
    }

    public RequestExecution prepare(RequestArguments arguments, RequestExecution execution) {
        return () -> {
            CompletableFuture original = ((AsyncFailsafe)((SyncFailsafe)Failsafe.with((RetryPolicy)this.retryPolicy).with(this.circuitBreaker)).with(this.scheduler).with((Listeners)new RetryListenersAdapter(this.listener, arguments))).future(() -> ((RequestExecution)execution).execute());
            CompletableFuture cancelable = CancelableCompletableFuture.preserveCancelability((Future)original);
            original.whenComplete(CancelableCompletableFuture.forwardTo((CompletableFuture)cancelable));
            return cancelable;
        };
    }

    private static final class RetryListenersAdapter
    extends Listeners<ClientHttpResponse> {
        private final RequestArguments arguments;
        private RetryListener listeners;

        public RetryListenersAdapter(RetryListener listeners, RequestArguments arguments) {
            this.arguments = arguments;
            this.listeners = listeners;
        }

        public void onRetry(ClientHttpResponse result, Throwable failure, ExecutionContext context) {
            this.listeners.onRetry(this.arguments, result, failure, context);
        }
    }
}

