/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import java.util.Collection;
import java.util.Objects;
import net.jodah.failsafe.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.riptide.failsafe.DelayParser;

final class CompoundDelayParser
implements DelayParser {
    private static final Logger log = LoggerFactory.getLogger(CompoundDelayParser.class);
    private final Collection<DelayParser> parsers;

    CompoundDelayParser(Collection<DelayParser> parsers) {
        this.parsers = parsers;
    }

    @Override
    public Duration parse(String value) {
        Duration delay = this.parsers.stream().map(parser -> parser.parse(value)).filter(Objects::nonNull).findFirst().orElse(null);
        if (delay == null) {
            log.warn("Received unsupported 'Retry-After' header [{}]; will ignore it", (Object)value);
        }
        return delay;
    }
}

