/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import net.jodah.failsafe.AsyncFailsafe;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Listeners;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.SyncFailsafe;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.CancelableCompletableFuture;
import org.zalando.riptide.Plugin;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.failsafe.RetryListener;

@API(status=API.Status.STABLE)
public final class FailsafePlugin
implements Plugin {
    private static final RetryPolicy NEVER = new RetryPolicy().withMaxRetries(0);
    private final ScheduledExecutorService scheduler;
    private final RetryPolicy retryPolicy;
    private final CircuitBreaker circuitBreaker;
    private final RetryListener listener;

    public FailsafePlugin(ScheduledExecutorService scheduler) {
        this(scheduler, NEVER, null, RetryListener.DEFAULT);
    }

    private FailsafePlugin(ScheduledExecutorService scheduler, RetryPolicy retryPolicy, @Nullable CircuitBreaker circuitBreaker, RetryListener listener) {
        this.scheduler = scheduler;
        this.retryPolicy = retryPolicy;
        this.circuitBreaker = circuitBreaker;
        this.listener = listener;
    }

    public FailsafePlugin withRetryPolicy(RetryPolicy retryPolicy) {
        return new FailsafePlugin(this.scheduler, retryPolicy, this.circuitBreaker, this.listener);
    }

    public FailsafePlugin withCircuitBreaker(CircuitBreaker circuitBreaker) {
        return new FailsafePlugin(this.scheduler, this.retryPolicy, circuitBreaker, this.listener);
    }

    public FailsafePlugin withListener(RetryListener listener) {
        return new FailsafePlugin(this.scheduler, this.retryPolicy, this.circuitBreaker, listener);
    }

    public RequestExecution prepare(RequestArguments arguments, RequestExecution execution) {
        return () -> {
            CompletableFuture original = ((AsyncFailsafe)this.failsafe().with(this.scheduler).with((Listeners)new RetryListenersAdapter(this.listener, arguments))).future(() -> ((RequestExecution)execution).execute());
            CompletableFuture cancelable = CancelableCompletableFuture.preserveCancelability((Future)original);
            original.whenComplete(CancelableCompletableFuture.forwardTo((CompletableFuture)cancelable));
            return cancelable;
        };
    }

    SyncFailsafe<Object> failsafe() {
        SyncFailsafe failsafe = Failsafe.with((RetryPolicy)this.retryPolicy);
        return this.circuitBreaker == null ? failsafe : (SyncFailsafe)failsafe.with(this.circuitBreaker);
    }

    @VisibleForTesting
    static final class RetryListenersAdapter
    extends Listeners<ClientHttpResponse> {
        private final RequestArguments arguments;
        private RetryListener listener;

        public RetryListenersAdapter(RetryListener listener, RequestArguments arguments) {
            this.arguments = arguments;
            this.listener = listener;
        }

        public void onRetry(ClientHttpResponse result, Throwable failure, ExecutionContext context) {
            this.listener.onRetry(this.arguments, result, failure, context);
        }
    }
}

