/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe.metrics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.time.Duration;
import java.util.Collections;
import javax.annotation.Nullable;
import net.jodah.failsafe.ExecutionContext;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.failsafe.RetryListener;
import org.zalando.riptide.metrics.DefaultTagGenerator;
import org.zalando.riptide.metrics.TagGenerator;

@API(status=API.Status.EXPERIMENTAL)
public final class MetricsRetryListener
implements RetryListener {
    private final MeterRegistry registry;
    private final String metricName;
    private final ImmutableList<Tag> defaultTags;
    private final TagGenerator generator = new DefaultTagGenerator();

    public MetricsRetryListener(MeterRegistry registry) {
        this(registry, "http.client.retries", (ImmutableList<Tag>)ImmutableList.of());
    }

    private MetricsRetryListener(MeterRegistry registry, String metricName, ImmutableList<Tag> defaultTags) {
        this.registry = registry;
        this.metricName = metricName;
        this.defaultTags = defaultTags;
    }

    public MetricsRetryListener withMetricName(String metricName) {
        return new MetricsRetryListener(this.registry, metricName, this.defaultTags);
    }

    public MetricsRetryListener withDefaultTags(Tag ... defaultTags) {
        return this.withDefaultTags((Iterable<Tag>)ImmutableList.copyOf((Object[])defaultTags));
    }

    public MetricsRetryListener withDefaultTags(Iterable<Tag> defaultTags) {
        return new MetricsRetryListener(this.registry, this.metricName, (ImmutableList<Tag>)ImmutableList.copyOf(defaultTags));
    }

    @Override
    public void onRetry(RequestArguments arguments, @Nullable ClientHttpResponse result, @Nullable Throwable failure, ExecutionContext context) {
        Iterable<Tag> tags = this.tags(arguments, result, failure, context);
        this.registry.timer(this.metricName, tags).record(Duration.ofNanos(context.getElapsedTime().toNanos()));
    }

    Iterable<Tag> tags(RequestArguments arguments, @Nullable ClientHttpResponse result, @Nullable Throwable failure, ExecutionContext context) {
        return Iterables.concat(this.tags(arguments, result, failure), this.tags(context));
    }

    Iterable<Tag> tags(RequestArguments arguments, @Nullable ClientHttpResponse response, @Nullable Throwable failure) {
        return Iterables.concat(this.defaultTags, (Iterable)this.generator.tags(arguments, response, failure));
    }

    private Iterable<Tag> tags(ExecutionContext context) {
        return Collections.singleton(Tag.of((String)"retries", (String)String.valueOf(context.getExecutions())));
    }
}

