/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.RetryPolicy;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.HttpResponseException;
import org.zalando.riptide.failsafe.CompositeDelayParser;
import org.zalando.riptide.failsafe.DelayParser;
import org.zalando.riptide.failsafe.HttpDateDelayParser;
import org.zalando.riptide.failsafe.SecondsDelayParser;

@API(status=API.Status.EXPERIMENTAL)
public final class RetryAfterDelayFunction
implements RetryPolicy.DelayFunction<ClientHttpResponse, Throwable> {
    private static final Logger log = LoggerFactory.getLogger(RetryAfterDelayFunction.class);
    private final DelayParser parser;

    public RetryAfterDelayFunction(Clock clock) {
        this.parser = new CompositeDelayParser(Arrays.asList(new SecondsDelayParser(), new HttpDateDelayParser(clock)));
    }

    public Duration computeDelay(ClientHttpResponse result, Throwable failure, ExecutionContext context) {
        return Optional.ofNullable(failure).filter(HttpResponseException.class::isInstance).map(HttpResponseException.class::cast).map(response -> response.getResponseHeaders().getFirst("Retry-After")).map(this.parser::parse).orElse(null);
    }
}

