/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.annotation.Nullable;
import org.zalando.riptide.failsafe.DelayParser;

final class HttpDateDelayParser
implements DelayParser {
    private final Clock clock;

    HttpDateDelayParser(Clock clock) {
        this.clock = clock;
    }

    @Override
    public Duration parse(String value) {
        return this.until(this.parseDate(value));
    }

    @Nullable
    private Instant parseDate(String value) {
        try {
            return Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(value));
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    @Nullable
    private Duration until(@Nullable Instant end) {
        return end == null ? null : Duration.between(Instant.now(this.clock), end);
    }
}

