/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import java.util.function.Predicate;
import net.jodah.failsafe.Policy;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.failsafe.ConditionalRequestPolicy;
import org.zalando.riptide.failsafe.DefaultRequestPolicy;

@API(status=API.Status.MAINTAINED)
public interface RequestPolicy {
    default public boolean applies(RequestArguments arguments) {
        return true;
    }

    public Policy<ClientHttpResponse> prepare(RequestArguments var1);

    public static RequestPolicy of(Policy<ClientHttpResponse> policy) {
        return new DefaultRequestPolicy(policy);
    }

    public static RequestPolicy of(Policy<ClientHttpResponse> policy, Predicate<RequestArguments> predicate) {
        return RequestPolicy.of(RequestPolicy.of(policy), predicate);
    }

    public static RequestPolicy of(RequestPolicy policy, Predicate<RequestArguments> predicate) {
        return new ConditionalRequestPolicy(policy, predicate);
    }
}

