/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.PolicyExecutor;
import net.jodah.failsafe.util.concurrent.Scheduler;
import org.zalando.riptide.CompletableFutures;
import org.zalando.riptide.failsafe.BackupRequest;

final class BackupRequestExecutor<R>
extends PolicyExecutor<BackupRequest<R>> {
    BackupRequestExecutor(BackupRequest<R> policy, AbstractExecution execution) {
        super(policy, execution);
    }

    protected Supplier<CompletableFuture<ExecutionResult>> supplyAsync(Supplier<CompletableFuture<ExecutionResult>> supplier, Scheduler scheduler, FailsafeFuture<Object> future) {
        return () -> {
            CompletableFuture original = (CompletableFuture)supplier.get();
            CompletableFuture<ExecutionResult> backup = new CompletableFuture<ExecutionResult>();
            ScheduledFuture<CompletableFuture<ExecutionResult>> scheduledBackup = this.delay(scheduler, this.backup(supplier, backup));
            original.whenComplete(this.cancel(scheduledBackup));
            backup.whenComplete(this.cancel(original));
            return this.anyOf(original, backup);
        };
    }

    private Callable<CompletableFuture<ExecutionResult>> backup(Supplier<CompletableFuture<ExecutionResult>> supplier, CompletableFuture<ExecutionResult> target) {
        return () -> ((CompletableFuture)supplier.get()).whenComplete(CompletableFutures.forwardTo((CompletableFuture)target));
    }

    private <T> ScheduledFuture<T> delay(Scheduler scheduler, Callable<T> callable) {
        long delay = ((BackupRequest)this.policy).getDelay();
        TimeUnit unit = ((BackupRequest)this.policy).getUnit();
        return scheduler.schedule(callable, delay, unit);
    }

    private <T> BiConsumer<T, Throwable> cancel(Future<?> future) {
        return (result, throwable) -> future.cancel(true);
    }

    @SafeVarargs
    private final <T> CompletableFuture<T> anyOf(CompletableFuture<? extends T> ... futures) {
        CompletableFuture any = new CompletableFuture();
        for (CompletableFuture<T> completableFuture : futures) {
            completableFuture.whenComplete(CompletableFutures.forwardTo(any));
        }
        return any;
    }
}

