/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import com.google.common.base.CharMatcher;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;
import lombok.Generated;
import org.zalando.riptide.failsafe.DelayParser;

final class EpochSecondsDelayParser
implements DelayParser {
    private final CharMatcher digit = CharMatcher.inRange((char)'0', (char)'9').precomputed();
    private final Clock clock;
    private final Duration threshold;

    EpochSecondsDelayParser(Clock clock) {
        this(clock, Duration.ofHours(-26L));
    }

    @Override
    public Duration parse(String value) {
        Instant instant = this.parseDate(value);
        if (instant == null) {
            return null;
        }
        Duration duration = Duration.between(Instant.now(this.clock), instant);
        if (duration.compareTo(this.threshold) > 0) {
            return duration;
        }
        return null;
    }

    @Nullable
    private Instant parseDate(String value) {
        if (this.isInteger(value)) {
            long epochSecond = Long.parseLong(value);
            return Instant.ofEpochSecond(epochSecond);
        }
        return null;
    }

    private boolean isInteger(String value) {
        return this.digit.matchesAllOf((CharSequence)value) && !value.isEmpty();
    }

    @Generated
    public EpochSecondsDelayParser(Clock clock, Duration threshold) {
        this.clock = clock;
        this.threshold = threshold;
    }
}

