/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe.metrics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.time.Duration;
import java.util.Collections;
import javax.annotation.Nullable;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.failsafe.RetryListener;
import org.zalando.riptide.micrometer.DefaultTagGenerator;
import org.zalando.riptide.micrometer.TagGenerator;

@API(status=API.Status.EXPERIMENTAL)
public final class MetricsRetryListener
implements RetryListener {
    private final MeterRegistry registry;
    private final String metricName;
    private final ImmutableList<Tag> defaultTags;
    private final TagGenerator generator = new DefaultTagGenerator();

    public MetricsRetryListener(MeterRegistry registry) {
        this(registry, "http.client.retries", (ImmutableList<Tag>)ImmutableList.of());
    }

    private MetricsRetryListener(MeterRegistry registry, String metricName, ImmutableList<Tag> defaultTags) {
        this.registry = registry;
        this.metricName = metricName;
        this.defaultTags = defaultTags;
    }

    public MetricsRetryListener withMetricName(String metricName) {
        return new MetricsRetryListener(this.registry, metricName, this.defaultTags);
    }

    public MetricsRetryListener withDefaultTags(Tag ... defaultTags) {
        return this.withDefaultTags((Iterable<Tag>)ImmutableList.copyOf((Object[])defaultTags));
    }

    public MetricsRetryListener withDefaultTags(Iterable<Tag> defaultTags) {
        return new MetricsRetryListener(this.registry, this.metricName, (ImmutableList<Tag>)ImmutableList.copyOf(defaultTags));
    }

    @Override
    public void onRetry(RequestArguments arguments, ExecutionAttemptedEvent<ClientHttpResponse> event) {
        Iterable<Tag> tags = this.tags(arguments, event);
        this.registry.timer(this.metricName, tags).record(Duration.ofNanos(event.getElapsedTime().toNanos()));
    }

    private Iterable<Tag> tags(RequestArguments arguments, ExecutionAttemptedEvent<ClientHttpResponse> event) {
        return Iterables.concat(this.tags(arguments, (ClientHttpResponse)event.getLastResult(), event.getLastFailure()), this.tags(event));
    }

    private Iterable<Tag> tags(RequestArguments arguments, @Nullable ClientHttpResponse response, @Nullable Throwable failure) {
        return Iterables.concat(this.defaultTags, (Iterable)this.generator.tags(arguments, response, failure));
    }

    private Iterable<Tag> tags(ExecutionAttemptedEvent<ClientHttpResponse> event) {
        return Collections.singleton(Tag.of((String)"retries", (String)String.valueOf(event.getAttemptCount())));
    }
}

