/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import net.jodah.failsafe.function.CheckedConsumer;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.Attribute;
import org.zalando.riptide.Plugin;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.failsafe.RetryListener;
import org.zalando.riptide.failsafe.TaskDecorator;
import org.zalando.riptide.idempotency.IdempotencyPredicate;

@API(status=API.Status.MAINTAINED)
public final class FailsafePlugin
implements Plugin {
    public static final Attribute<Integer> ATTEMPTS = Attribute.generate();
    private final ImmutableList<? extends Policy<ClientHttpResponse>> policies;
    private final TaskDecorator decorator;
    private final Predicate<RequestArguments> predicate;
    private final RetryListener listener;

    public FailsafePlugin(ImmutableList<? extends Policy<ClientHttpResponse>> policies) {
        this(policies, TaskDecorator.identity(), (Predicate<RequestArguments>)new IdempotencyPredicate(), RetryListener.DEFAULT);
    }

    public FailsafePlugin withDecorator(TaskDecorator decorator) {
        return new FailsafePlugin(this.policies, decorator, this.predicate, this.listener);
    }

    public FailsafePlugin withPredicate(Predicate<RequestArguments> predicate) {
        return new FailsafePlugin(this.policies, this.decorator, predicate, this.listener);
    }

    public FailsafePlugin withListener(RetryListener listener) {
        return new FailsafePlugin(this.policies, this.decorator, this.predicate, listener);
    }

    public RequestExecution aroundAsync(RequestExecution execution) {
        return arguments -> {
            Policy<ClientHttpResponse>[] policies = this.select(arguments);
            if (policies.length == 0) {
                return execution.execute(arguments);
            }
            return Failsafe.with(this.select(arguments)).getStageAsync(this.decorator.decorate(context -> execution.execute(this.withAttempts(arguments, context.getAttemptCount()))));
        };
    }

    private Policy<ClientHttpResponse>[] select(RequestArguments arguments) {
        Stream stream = this.policies.stream().filter(this.skipRetriesIfNeeded(arguments)).map(this.withRetryListener(arguments));
        Policy[] policies = (Policy[])stream.toArray(Policy[]::new);
        return policies;
    }

    private Predicate<Policy<ClientHttpResponse>> skipRetriesIfNeeded(RequestArguments arguments) {
        return this.predicate.test(arguments) ? policy -> true : policy -> !(policy instanceof RetryPolicy);
    }

    private UnaryOperator<Policy<ClientHttpResponse>> withRetryListener(RequestArguments arguments) {
        return policy -> {
            if (policy instanceof RetryPolicy) {
                RetryPolicy retryPolicy = (RetryPolicy)policy;
                return retryPolicy.copy().onFailedAttempt((CheckedConsumer)new RetryListenerAdapter(this.listener, arguments));
            }
            return policy;
        };
    }

    private RequestArguments withAttempts(RequestArguments arguments, int attempts) {
        if (attempts == 0) {
            return arguments;
        }
        return arguments.withAttribute(ATTEMPTS, (Object)attempts);
    }

    private FailsafePlugin(ImmutableList<? extends Policy<ClientHttpResponse>> policies, TaskDecorator decorator, Predicate<RequestArguments> predicate, RetryListener listener) {
        this.policies = policies;
        this.decorator = decorator;
        this.predicate = predicate;
        this.listener = listener;
    }

    @VisibleForTesting
    static final class RetryListenerAdapter
    implements CheckedConsumer<ExecutionAttemptedEvent<ClientHttpResponse>> {
        private final RetryListener listener;
        private final RequestArguments arguments;

        public void accept(ExecutionAttemptedEvent<ClientHttpResponse> event) {
            this.listener.onRetry(this.arguments, event);
        }

        public RetryListenerAdapter(RetryListener listener, RequestArguments arguments) {
            this.listener = listener;
            this.arguments = arguments;
        }
    }
}

