/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.failsafe.RetryListener;

@API(status=API.Status.EXPERIMENTAL)
public final class LoggingRetryListener
implements RetryListener {
    private final Logger logger;

    public LoggingRetryListener() {
        this(LoggerFactory.getLogger(LoggingRetryListener.class));
    }

    public LoggingRetryListener(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void onRetry(RequestArguments arguments, ExecutionAttemptedEvent<ClientHttpResponse> event) {
        if (event.getLastFailure() != null) {
            this.logger.warn("Retrying failure", event.getLastFailure());
        }
    }
}

