/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.function.DelayFunction;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class CompositeDelayFunction<R, X extends Throwable>
implements DelayFunction<R, X> {
    private final Collection<DelayFunction<R, X>> functions;

    public Duration computeDelay(R result, X failure, ExecutionContext context) {
        return this.functions.stream().map(function -> function.computeDelay(result, failure, context)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @SafeVarargs
    public static <R, X extends Throwable> DelayFunction<R, X> composite(DelayFunction<R, X> ... functions) {
        return new CompositeDelayFunction<R, X>(Arrays.asList(functions));
    }

    public CompositeDelayFunction(Collection<DelayFunction<R, X>> functions) {
        this.functions = functions;
    }
}

