/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe.metrics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import net.jodah.failsafe.CircuitBreaker;
import org.apiguardian.api.API;
import org.zalando.riptide.failsafe.CircuitBreakerListener;

@API(status=API.Status.EXPERIMENTAL)
public final class MetricsCircuitBreakerListener
implements CircuitBreakerListener {
    private final MeterRegistry registry;
    private final String metricName;
    private final ImmutableList<Tag> defaultTags;
    private final AtomicReference<CircuitBreaker.State> state = new AtomicReference<CircuitBreaker.State>(CircuitBreaker.State.CLOSED);
    private final AtomicReference<Timer.Sample> sample;

    public MetricsCircuitBreakerListener(MeterRegistry registry) {
        this(registry, "http.client.circuit-breakers", (ImmutableList<Tag>)ImmutableList.of());
    }

    @API(status=API.Status.INTERNAL)
    MetricsCircuitBreakerListener(MeterRegistry registry, String metricName, ImmutableList<Tag> defaultTags) {
        this(registry, metricName, defaultTags, new AtomicReference<Timer.Sample>(Timer.start((MeterRegistry)registry)));
    }

    public MetricsCircuitBreakerListener withMetricName(String metricName) {
        return new MetricsCircuitBreakerListener(this.registry, metricName, this.defaultTags);
    }

    public MetricsCircuitBreakerListener withDefaultTags(Tag ... defaultTags) {
        return this.withDefaultTags((Iterable<Tag>)ImmutableList.copyOf((Object[])defaultTags));
    }

    public MetricsCircuitBreakerListener withDefaultTags(Iterable<Tag> defaultTags) {
        return new MetricsCircuitBreakerListener(this.registry, this.metricName, (ImmutableList<Tag>)ImmutableList.copyOf(defaultTags));
    }

    @Override
    public void onOpen() {
        this.on(CircuitBreaker.State.OPEN);
    }

    @Override
    public void onHalfOpen() {
        this.on(CircuitBreaker.State.HALF_OPEN);
    }

    @Override
    public void onClose() {
        this.on(CircuitBreaker.State.CLOSED);
    }

    private void on(CircuitBreaker.State to) {
        CircuitBreaker.State from = this.state.getAndSet(to);
        Timer.Sample last = this.sample.getAndSet(Timer.start((MeterRegistry)this.registry));
        if (from != CircuitBreaker.State.CLOSED) {
            last.stop(this.registry.timer(this.metricName, this.tags(from)));
        }
    }

    private Iterable<Tag> tags(CircuitBreaker.State state) {
        return Iterables.concat(this.defaultTags, Collections.singleton(Tag.of((String)"state", (String)state.name())));
    }

    private MetricsCircuitBreakerListener(MeterRegistry registry, String metricName, ImmutableList<Tag> defaultTags, AtomicReference<Timer.Sample> sample) {
        this.registry = registry;
        this.metricName = metricName;
        this.defaultTags = defaultTags;
        this.sample = sample;
    }
}

