/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.function.DelayFunction;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.HttpResponseException;
import org.zalando.riptide.failsafe.CompositeDelayParser;
import org.zalando.riptide.failsafe.DelayParser;
import org.zalando.riptide.failsafe.EpochSecondsDelayParser;
import org.zalando.riptide.failsafe.SecondsDelayParser;

@API(status=API.Status.EXPERIMENTAL)
public final class RateLimitResetDelayFunction
implements DelayFunction<ClientHttpResponse, Throwable> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimitResetDelayFunction.class);
    private final DelayParser parser;

    public RateLimitResetDelayFunction(Clock clock) {
        this.parser = new CompositeDelayParser(Arrays.asList(new EpochSecondsDelayParser(clock), new SecondsDelayParser()));
    }

    public Duration computeDelay(ClientHttpResponse result, Throwable failure, ExecutionContext context) {
        return Optional.ofNullable(failure).filter(HttpResponseException.class::isInstance).map(HttpResponseException.class::cast).map(response -> response.getResponseHeaders().getFirst("X-RateLimit-Reset")).map(this.parser::parse).orElse(null);
    }
}

