/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.soap;

import net.jodah.failsafe.function.ContextualSupplier;
import org.apiguardian.api.API;
import org.zalando.riptide.failsafe.TaskDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class PreserveContextClassLoaderTaskDecorator
implements TaskDecorator {
    @Override
    public <T> ContextualSupplier<T> decorate(ContextualSupplier<T> supplier) {
        Thread currentThread = Thread.currentThread();
        ClassLoader original = currentThread.getContextClassLoader();
        return context -> {
            try {
                currentThread.setContextClassLoader(original);
                Object object = supplier.get(context);
                return object;
            }
            finally {
                currentThread.setContextClassLoader(original);
            }
        };
    }
}

