/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.function.ContextualSupplier;
import org.apiguardian.api.API;
import org.organicdesign.fp.StaticImports;
import org.organicdesign.fp.collections.ImList;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.Attributes;
import org.zalando.riptide.Plugin;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.failsafe.RequestPolicies;
import org.zalando.riptide.failsafe.RequestPolicy;
import org.zalando.riptide.failsafe.TaskDecorator;

@API(status=API.Status.MAINTAINED)
public final class FailsafePlugin
implements Plugin {
    private final ImList<RequestPolicy> policies;
    private final ImList<TaskDecorator> decorators;

    public FailsafePlugin() {
        this((ImList<RequestPolicy>)StaticImports.vec((Object[])new RequestPolicy[0]), (ImList<TaskDecorator>)StaticImports.vec((Object[])new TaskDecorator[0]));
    }

    public FailsafePlugin withPolicy(Policy<ClientHttpResponse> policy) {
        return this.withPolicy(RequestPolicies.of(policy));
    }

    public FailsafePlugin withPolicy(Policy<ClientHttpResponse> policy, Predicate<RequestArguments> predicate) {
        return this.withPolicy(RequestPolicies.of(policy, predicate));
    }

    public FailsafePlugin withPolicy(RequestPolicy policy) {
        return new FailsafePlugin((ImList<RequestPolicy>)this.policies.append((Object)policy), this.decorators);
    }

    public FailsafePlugin withDecorator(TaskDecorator decorator) {
        return new FailsafePlugin(this.policies, (ImList<TaskDecorator>)this.decorators.append((Object)decorator));
    }

    public RequestExecution aroundAsync(RequestExecution execution) {
        return arguments -> {
            List<Policy<ClientHttpResponse>> policies = this.select(arguments);
            if (policies.isEmpty()) {
                return execution.execute(arguments);
            }
            return Failsafe.with(this.select(arguments)).getStageAsync(this.decorate(execution, arguments));
        };
    }

    private ContextualSupplier<CompletableFuture<ClientHttpResponse>> decorate(RequestExecution execution, RequestArguments arguments) {
        TaskDecorator decorator = TaskDecorator.composite(this.decorators);
        return decorator.decorate(context -> execution.execute(this.withAttempts(arguments, context.getAttemptCount())));
    }

    private List<Policy<ClientHttpResponse>> select(RequestArguments arguments) {
        return this.policies.stream().filter(policy -> policy.applies(arguments)).map(policy -> policy.prepare(arguments)).collect(Collectors.toList());
    }

    private RequestArguments withAttempts(RequestArguments arguments, int attempts) {
        if (attempts == 0) {
            return arguments;
        }
        return arguments.withAttribute(Attributes.RETRIES, (Object)attempts);
    }

    @Generated
    private FailsafePlugin(ImList<RequestPolicy> policies, ImList<TaskDecorator> decorators) {
        this.policies = policies;
        this.decorators = decorators;
    }
}

