/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import java.util.function.Predicate;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.failsafe.BackupRequest;
import org.zalando.riptide.failsafe.ConditionalRequestPolicy;
import org.zalando.riptide.failsafe.DefaultRequestPolicy;
import org.zalando.riptide.failsafe.RequestPolicy;
import org.zalando.riptide.failsafe.RetryRequestPolicy;
import org.zalando.riptide.idempotency.IdempotencyPredicate;

@API(status=API.Status.EXPERIMENTAL)
public final class RequestPolicies {
    private RequestPolicies() {
    }

    public static RequestPolicy of(Policy<ClientHttpResponse> policy) {
        if (policy instanceof BackupRequest) {
            return new ConditionalRequestPolicy(new DefaultRequestPolicy(policy), (Predicate<RequestArguments>)new IdempotencyPredicate());
        }
        if (policy instanceof RetryPolicy) {
            return new RetryRequestPolicy((RetryPolicy<ClientHttpResponse>)((RetryPolicy)policy));
        }
        return new DefaultRequestPolicy(policy);
    }

    public static RequestPolicy of(Policy<ClientHttpResponse> policy, Predicate<RequestArguments> predicate) {
        return RequestPolicies.of(RequestPolicies.of(policy), predicate);
    }

    public static RequestPolicy of(RequestPolicy policy, Predicate<RequestArguments> predicate) {
        return new ConditionalRequestPolicy(policy, predicate);
    }
}

