/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import dev.failsafe.spi.AsyncExecutionInternal;
import dev.failsafe.spi.ExecutionResult;
import dev.failsafe.spi.FailsafeFuture;
import dev.failsafe.spi.PolicyExecutor;
import dev.failsafe.spi.Scheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.zalando.riptide.CompletableFutures;
import org.zalando.riptide.failsafe.BackupRequest;

final class BackupRequestExecutor<R>
extends PolicyExecutor<R> {
    private final BackupRequest<R> policy;

    BackupRequestExecutor(BackupRequest<R> policy, int policyIndex) {
        super(policy, policyIndex);
        this.policy = policy;
    }

    public Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> applyAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn, Scheduler scheduler, FailsafeFuture<R> future) {
        return asyncExecutionInternal -> {
            CompletableFuture original = (CompletableFuture)innerFn.apply((AsyncExecutionInternal<R>)asyncExecutionInternal);
            CompletableFuture<ExecutionResult<R>> backup = new CompletableFuture<ExecutionResult<R>>();
            ScheduledFuture<CompletableFuture<ExecutionResult<R>>> scheduledBackup = this.delay(scheduler, this.backup(innerFn, (AsyncExecutionInternal<R>)asyncExecutionInternal, backup));
            original.whenComplete(this.cancel(scheduledBackup));
            backup.whenComplete(this.cancel(original));
            return this.anyOf(original, backup);
        };
    }

    private Callable<CompletableFuture<ExecutionResult<R>>> backup(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn, AsyncExecutionInternal<R> asyncExecutionInternal, CompletableFuture<ExecutionResult<R>> target) {
        return () -> ((CompletableFuture)innerFn.apply(asyncExecutionInternal)).whenComplete(CompletableFutures.forwardTo((CompletableFuture)target));
    }

    private <T> ScheduledFuture<T> delay(Scheduler scheduler, Callable<T> callable) {
        long delay = this.policy.getDelay();
        TimeUnit unit = this.policy.getUnit();
        return scheduler.schedule(callable, delay, unit);
    }

    private <T> BiConsumer<T, Throwable> cancel(Future<?> future) {
        return (result, throwable) -> future.cancel(true);
    }

    @SafeVarargs
    private final <T> CompletableFuture<T> anyOf(CompletableFuture<? extends T> ... futures) {
        CompletableFuture any = new CompletableFuture();
        for (CompletableFuture<T> completableFuture : futures) {
            completableFuture.whenComplete(CompletableFutures.forwardTo(any));
        }
        return any;
    }
}

