/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.soap;

import dev.failsafe.function.ContextualSupplier;
import org.apiguardian.api.API;
import org.zalando.riptide.failsafe.TaskDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class PreserveContextClassLoaderTaskDecorator
implements TaskDecorator {
    @Override
    public <T, R> ContextualSupplier<T, R> decorate(ContextualSupplier<T, R> supplier) {
        ClassLoader invokingThreadCL = Thread.currentThread().getContextClassLoader();
        return context -> {
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(invokingThreadCL);
                Object object = supplier.get(context);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        };
    }
}

