/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import dev.failsafe.ExecutionContext;
import dev.failsafe.function.ContextualSupplier;
import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.HttpResponseException;
import org.zalando.riptide.failsafe.CompositeDelayParser;
import org.zalando.riptide.failsafe.DelayParser;
import org.zalando.riptide.failsafe.EpochSecondsDelayParser;
import org.zalando.riptide.failsafe.SecondsDelayParser;

@API(status=API.Status.EXPERIMENTAL)
public final class RateLimitResetDelayFunction
implements ContextualSupplier<ClientHttpResponse, Duration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimitResetDelayFunction.class);
    private final DelayParser parser;

    public RateLimitResetDelayFunction(Clock clock) {
        this.parser = new CompositeDelayParser(Arrays.asList(new EpochSecondsDelayParser(clock), new SecondsDelayParser()));
    }

    public Duration get(ExecutionContext<ClientHttpResponse> context) {
        return Optional.ofNullable(context).map(ExecutionContext::getLastException).filter(HttpResponseException.class::isInstance).map(HttpResponseException.class::cast).map(response -> response.getResponseHeaders().getFirst("X-RateLimit-Reset")).map(this.parser::parse).orElse(Duration.ofMinutes(-1L));
    }
}

