/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import dev.failsafe.ExecutionContext;
import dev.failsafe.function.ContextualSupplier;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class CompositeDelayFunction<R>
implements ContextualSupplier<R, Duration> {
    private final Collection<ContextualSupplier<R, Duration>> functions;

    public Duration get(ExecutionContext<R> context) throws Throwable {
        return this.functions.stream().map(function -> {
            try {
                return (Duration)function.get(context);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @SafeVarargs
    public static <R, X extends Throwable> ContextualSupplier<R, Duration> composite(ContextualSupplier<R, Duration> ... functions) {
        return new CompositeDelayFunction<R>(Arrays.asList(functions));
    }

    @Generated
    public CompositeDelayFunction(Collection<ContextualSupplier<R, Duration>> functions) {
        this.functions = functions;
    }
}

