/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.riptide.failsafe.DelayParser;

final class CompositeDelayParser
implements DelayParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompositeDelayParser.class);
    private final Collection<DelayParser> parsers;

    @Override
    public Duration parse(String value) {
        Duration delay = this.parsers.stream().map(parser -> parser.parse(value)).filter(Objects::nonNull).findFirst().orElse(null);
        if (delay == null) {
            log.warn("Received unsupported 'Retry-After' header [{}]; will ignore it", (Object)value);
        }
        return delay;
    }

    @Generated
    public CompositeDelayParser(Collection<DelayParser> parsers) {
        this.parsers = parsers;
    }
}

