/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.failsafe;

import com.google.common.annotations.VisibleForTesting;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyConfig;
import dev.failsafe.event.EventListener;
import dev.failsafe.event.ExecutionAttemptedEvent;
import java.util.function.Predicate;
import lombok.Generated;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.failsafe.RequestPolicy;
import org.zalando.riptide.failsafe.RetryListener;
import org.zalando.riptide.idempotency.IdempotencyPredicate;

@API(status=API.Status.EXPERIMENTAL)
public final class RetryRequestPolicy
implements RequestPolicy {
    private final RetryPolicy<ClientHttpResponse> policy;
    private final Predicate<RequestArguments> predicate;
    private final RetryListener listener;

    public RetryRequestPolicy(RetryPolicy<ClientHttpResponse> policy) {
        this(policy, (Predicate<RequestArguments>)new IdempotencyPredicate(), RetryListener.DEFAULT);
    }

    public RetryRequestPolicy withPredicate(Predicate<RequestArguments> predicate) {
        return new RetryRequestPolicy(this.policy, predicate, this.listener);
    }

    public RetryRequestPolicy withListener(RetryListener listener) {
        return new RetryRequestPolicy(this.policy, this.predicate, listener);
    }

    @Override
    public boolean applies(RequestArguments arguments) {
        return this.predicate.test(arguments);
    }

    @Override
    public Policy<ClientHttpResponse> prepare(RequestArguments arguments) {
        return RetryPolicy.builder((RetryPolicyConfig)this.policy.getConfig()).onFailedAttempt((EventListener)new RetryListenerAdapter(this.listener, arguments)).build();
    }

    @Generated
    private RetryRequestPolicy(RetryPolicy<ClientHttpResponse> policy, Predicate<RequestArguments> predicate, RetryListener listener) {
        this.policy = policy;
        this.predicate = predicate;
        this.listener = listener;
    }

    @VisibleForTesting
    static final class RetryListenerAdapter
    implements EventListener<ExecutionAttemptedEvent<ClientHttpResponse>> {
        private final RetryListener listener;
        private final RequestArguments arguments;

        public void accept(ExecutionAttemptedEvent<ClientHttpResponse> event) {
            this.listener.onRetry(this.arguments, event);
        }

        @Generated
        public RetryListenerAdapter(RetryListener listener, RequestArguments arguments) {
            this.listener = listener;
            this.arguments = arguments;
        }
    }
}

