/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.faults;

import java.io.InterruptedIOException;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.net.ssl.SSLHandshakeException;
import org.zalando.riptide.faults.DefaultFaultClassifier;

public interface FaultClassifier {
    public Throwable classify(Throwable var1);

    default public <T> T classifyExceptionally(Throwable throwable) throws Throwable {
        throw this.classify(throwable);
    }

    public static FaultClassifier createDefault() {
        return FaultClassifier.create(FaultClassifier.defaults());
    }

    public static List<Predicate<Throwable>> defaults() {
        Predicate[] predicateArray = new Predicate[3];
        predicateArray[0] = InterruptedIOException.class::isInstance;
        predicateArray[1] = SocketException.class::isInstance;
        predicateArray[2] = throwable -> throwable instanceof SSLHandshakeException && "Remote host closed connection during handshake".equals(throwable.getMessage());
        return Collections.unmodifiableList(Arrays.asList(predicateArray));
    }

    @SafeVarargs
    public static FaultClassifier create(Predicate<Throwable> ... predicates) {
        return FaultClassifier.create(Arrays.asList(predicates));
    }

    public static FaultClassifier create(Collection<Predicate<Throwable>> predicates) {
        Predicate<Throwable> isTransient = predicates.stream().reduce(Predicate::or).orElse(throwable -> false);
        return new DefaultFaultClassifier(isTransient);
    }
}

