/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.faults;

import com.google.common.base.Throwables;
import java.util.function.Predicate;
import org.zalando.riptide.faults.FaultClassifier;
import org.zalando.riptide.faults.TransientFaultException;

final class DefaultFaultClassifier
implements FaultClassifier {
    private final Predicate<Throwable> isTransient;

    public DefaultFaultClassifier(Predicate<Throwable> isTransient) {
        this.isTransient = isTransient;
    }

    @Override
    public Throwable classify(Throwable throwable) {
        for (Throwable cause : Throwables.getCausalChain((Throwable)throwable)) {
            if (!this.isTransient.test(cause)) continue;
            return new TransientFaultException(throwable);
        }
        return throwable;
    }
}

