/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.faults;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.zalando.riptide.faults.CausalChainClassificationStrategy;
import org.zalando.riptide.faults.ClassificationStrategy;
import org.zalando.riptide.faults.FaultClassifier;
import org.zalando.riptide.faults.TransientFaultException;

public final class DefaultFaultClassifier
implements FaultClassifier {
    private final ClassificationStrategy strategy;
    private final Predicate<Throwable> included;
    private final Predicate<Throwable> excluded;

    public DefaultFaultClassifier() {
        this(new CausalChainClassificationStrategy());
    }

    public DefaultFaultClassifier(ClassificationStrategy strategy) {
        Predicate[] predicateArray = new Predicate[2];
        predicateArray[0] = throwable -> throwable instanceof SSLException && (!(throwable instanceof SSLHandshakeException) || !"Remote host closed connection during handshake".equals(throwable.getMessage()));
        predicateArray[1] = MalformedURLException.class::isInstance;
        this(strategy, IOException.class::isInstance, DefaultFaultClassifier.merge(UnknownHostException.class::isInstance, predicateArray));
    }

    @SafeVarargs
    private static Predicate<Throwable> merge(Predicate<Throwable> predicate, Predicate<Throwable> ... predicates) {
        return Stream.of(predicates).reduce(predicate, Predicate::or);
    }

    public DefaultFaultClassifier include(Predicate<Throwable> predicate) {
        return new DefaultFaultClassifier(this.strategy, this.included.or(predicate), this.excluded);
    }

    public DefaultFaultClassifier exclude(Predicate<Throwable> predicate) {
        return new DefaultFaultClassifier(this.strategy, this.included, this.excluded.or(predicate));
    }

    @Override
    public Throwable classify(Throwable throwable) {
        if (throwable instanceof TransientFaultException) {
            return throwable;
        }
        if (!this.strategy.test(throwable, this.excluded) && this.strategy.test(throwable, this.included)) {
            return new TransientFaultException(throwable);
        }
        return throwable;
    }

    public DefaultFaultClassifier(ClassificationStrategy strategy, Predicate<Throwable> included, Predicate<Throwable> excluded) {
        this.strategy = strategy;
        this.included = included;
        this.excluded = excluded;
    }
}

