/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.faults;

import com.google.common.base.Throwables;
import java.util.List;
import java.util.function.Predicate;

public interface ClassificationStrategy {
    public boolean test(Throwable var1, Predicate<Throwable> var2);

    public static ClassificationStrategy self() {
        return (throwable, predicate) -> predicate.test(throwable);
    }

    public static ClassificationStrategy causalChain() {
        return (throwable, predicate) -> {
            List chain = Throwables.getCausalChain((Throwable)throwable);
            return chain.stream().anyMatch(predicate);
        };
    }

    public static ClassificationStrategy rootCause() {
        return (throwable, predicate) -> predicate.test(Throwables.getRootCause((Throwable)throwable));
    }
}

