/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.faults;

import java.util.function.Predicate;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.riptide.faults.Predicates;

@API(status=API.Status.EXPERIMENTAL)
public final class Rule<T>
implements Predicate<T> {
    private final Predicate<T> include;
    private final Predicate<T> exclude;

    @Override
    public boolean test(T input) {
        return this.include.test(input) && !this.exclude.test(input);
    }

    public static <T> Rule<T> of() {
        return Rule.of(Predicates.alwaysTrue());
    }

    public static <T> Rule<T> of(Predicate<T> predicate) {
        return Rule.of(predicate, Predicates.alwaysFalse());
    }

    public Rule<T> include(Predicate<T> predicate) {
        return this.withInclude(this.include.and(predicate));
    }

    public Rule<T> exclude(Predicate<T> predicate) {
        return this.withExclude(this.exclude.or(predicate));
    }

    @Generated
    private Rule(Predicate<T> include, Predicate<T> exclude) {
        this.include = include;
        this.exclude = exclude;
    }

    @Generated
    public static <T> Rule<T> of(Predicate<T> include, Predicate<T> exclude) {
        return new Rule<T>(include, exclude);
    }

    @Generated
    private Rule<T> withInclude(Predicate<T> include) {
        return this.include == include ? this : new Rule<T>(include, this.exclude);
    }

    @Generated
    private Rule<T> withExclude(Predicate<T> exclude) {
        return this.exclude == exclude ? this : new Rule<T>(this.include, exclude);
    }
}

