/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.hystrix;

import com.netflix.hystrix.HystrixObservableCommand;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.Plugin;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.hystrix.CompletableFutureObservable;
import org.zalando.riptide.hystrix.DefaultSetterFactory;
import org.zalando.riptide.hystrix.ObservableCompletableFuture;
import org.zalando.riptide.hystrix.SetterFactory;
import rx.Observable;

public final class HystrixPlugin
implements Plugin {
    private final SetterFactory factory;

    public HystrixPlugin() {
        this(null);
    }

    public HystrixPlugin(@Nullable SetterFactory factory) {
        this.factory = Optional.ofNullable(factory).orElseGet(DefaultSetterFactory::new);
    }

    public RequestExecution prepare(RequestArguments arguments, final RequestExecution execution) {
        return () -> {
            HystrixObservableCommand<ClientHttpResponse> command = new HystrixObservableCommand<ClientHttpResponse>(this.factory.create(arguments)){

                protected Observable<ClientHttpResponse> construct() {
                    try {
                        return new CompletableFutureObservable<ClientHttpResponse>(execution.execute());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
            return new ObservableCompletableFuture(command.observe());
        };
    }
}

