/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.micrometer;

import com.google.common.base.MoreObjects;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.micrometer.TagGenerator;

@API(status=API.Status.EXPERIMENTAL)
public final class DefaultTagGenerator
implements TagGenerator {
    @Override
    public Iterable<Tag> tags(RequestArguments arguments, @Nullable ClientHttpResponse response, @Nullable Throwable throwable) {
        return Arrays.asList(Tag.of((String)"method", (String)this.method(arguments)), Tag.of((String)"uri", (String)this.uri(arguments)), Tag.of((String)"status", (String)this.status(response)), Tag.of((String)"clientName", (String)this.client(arguments)), Tag.of((String)"exception", (String)this.exception(throwable)));
    }

    private String method(RequestArguments arguments) {
        return arguments.getMethod().name();
    }

    private String uri(RequestArguments arguments) {
        return (String)MoreObjects.firstNonNull((Object)arguments.getUriTemplate(), (Object)arguments.getRequestUri().getPath());
    }

    private String status(@Nullable ClientHttpResponse response) {
        if (response == null) {
            return "CLIENT_ERROR";
        }
        try {
            return String.valueOf(response.getRawStatusCode());
        }
        catch (IOException e) {
            return "IO_ERROR";
        }
    }

    private String client(RequestArguments arguments) {
        return (String)MoreObjects.firstNonNull((Object)arguments.getRequestUri().getHost(), (Object)"none");
    }

    private String exception(@Nullable Throwable throwable) {
        return throwable == null ? "None" : throwable.getClass().getSimpleName();
    }
}

