/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.micrometer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.Plugin;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.micrometer.DefaultTagGenerator;
import org.zalando.riptide.micrometer.TagGenerator;

@API(status=API.Status.EXPERIMENTAL)
public final class MicrometerPlugin
implements Plugin {
    private final MeterRegistry registry;
    private final String metricName;
    private final ImmutableList<Tag> defaultTags;
    private final TagGenerator generator = new DefaultTagGenerator();

    public MicrometerPlugin(MeterRegistry registry) {
        this(registry, "http.client.requests", (ImmutableList<Tag>)ImmutableList.of());
    }

    private MicrometerPlugin(MeterRegistry registry, String metricName, ImmutableList<Tag> defaultTags) {
        this.registry = registry;
        this.metricName = metricName;
        this.defaultTags = defaultTags;
    }

    public MicrometerPlugin withMetricName(String metricName) {
        return new MicrometerPlugin(this.registry, metricName, this.defaultTags);
    }

    public MicrometerPlugin withDefaultTags(Tag ... defaultTags) {
        return this.withDefaultTags((Iterable<Tag>)ImmutableList.copyOf((Object[])defaultTags));
    }

    public MicrometerPlugin withDefaultTags(Iterable<Tag> defaultTags) {
        return new MicrometerPlugin(this.registry, this.metricName, (ImmutableList<Tag>)ImmutableList.copyOf(defaultTags));
    }

    public RequestExecution aroundNetwork(RequestExecution execution) {
        return arguments -> {
            Measurement measurement = new Measurement(arguments);
            return execution.execute(arguments).whenComplete(measurement::record);
        };
    }

    private final class Measurement {
        private final Timer.Sample sample;
        private final RequestArguments arguments;

        void record(ClientHttpResponse response, Throwable throwable) {
            Iterable tags = Iterables.concat((Iterable)MicrometerPlugin.this.defaultTags, MicrometerPlugin.this.generator.tags(this.arguments, response, throwable));
            Timer timer = MicrometerPlugin.this.registry.timer(MicrometerPlugin.this.metricName, tags);
            this.sample.stop(timer);
        }

        public Measurement(RequestArguments arguments) {
            this.sample = Timer.start((MeterRegistry)MicrometerPlugin.this.registry);
            this.arguments = arguments;
        }
    }
}

