/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.micrometer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.fauxpas.FauxPas;
import org.zalando.fauxpas.ThrowingUnaryOperator;
import org.zalando.riptide.Attribute;
import org.zalando.riptide.Plugin;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.micrometer.tag.CallSiteTagGenerator;
import org.zalando.riptide.micrometer.tag.ErrorKindTagGenerator;
import org.zalando.riptide.micrometer.tag.HttpMethodTagGenerator;
import org.zalando.riptide.micrometer.tag.HttpPathTagGenerator;
import org.zalando.riptide.micrometer.tag.HttpStatusTagGenerator;
import org.zalando.riptide.micrometer.tag.PeerHostnameTagGenerator;
import org.zalando.riptide.micrometer.tag.ServiceLoaderTagGenerator;
import org.zalando.riptide.micrometer.tag.TagGenerator;

@API(status=API.Status.EXPERIMENTAL)
public final class MicrometerPlugin
implements Plugin {
    public static final Attribute<Tags> TAGS = Attribute.generate();
    private final MeterRegistry registry;
    private final String metricName;
    private final ImmutableList<Tag> defaultTags;
    private final TagGenerator generator;

    public MicrometerPlugin(MeterRegistry registry) {
        this(registry, "http.client.requests", (ImmutableList<Tag>)ImmutableList.of(), TagGenerator.composite(new CallSiteTagGenerator(), new ErrorKindTagGenerator(), new HttpMethodTagGenerator(), new HttpPathTagGenerator(), new HttpStatusTagGenerator(), new PeerHostnameTagGenerator(), new ServiceLoaderTagGenerator()));
    }

    public MicrometerPlugin withMetricName(String metricName) {
        return new MicrometerPlugin(this.registry, metricName, this.defaultTags, this.generator);
    }

    public MicrometerPlugin withDefaultTags(Tag ... defaultTags) {
        return this.withDefaultTags((Iterable<Tag>)ImmutableList.copyOf((Object[])defaultTags));
    }

    public MicrometerPlugin withDefaultTags(Iterable<Tag> defaultTags) {
        return new MicrometerPlugin(this.registry, this.metricName, (ImmutableList<Tag>)ImmutableList.copyOf(defaultTags), this.generator);
    }

    public MicrometerPlugin withAdditionalTagGenerators(TagGenerator first, TagGenerator ... rest) {
        return this.withAdditionalTagGenerators(Lists.asList((Object)first, (Object[])rest));
    }

    public MicrometerPlugin withAdditionalTagGenerators(Collection<TagGenerator> generators) {
        return this.withTagGenerators(TagGenerator.composite(this.generator, TagGenerator.composite(generators)), new TagGenerator[0]);
    }

    public MicrometerPlugin withTagGenerators(TagGenerator generator, TagGenerator ... generators) {
        return this.withTagGenerators(Lists.asList((Object)generator, (Object[])generators));
    }

    public MicrometerPlugin withTagGenerators(Collection<TagGenerator> generators) {
        return new MicrometerPlugin(this.registry, this.metricName, this.defaultTags, TagGenerator.composite(generators));
    }

    public RequestExecution aroundNetwork(RequestExecution execution) {
        return arguments -> {
            Measurement measurement = new Measurement(arguments);
            return ((CompletableFuture)execution.execute(arguments).whenComplete((BiConsumer)FauxPas.throwingBiConsumer((response, throwable) -> {
                if (Objects.nonNull(response)) {
                    measurement.record((ClientHttpResponse)response);
                }
            }))).whenComplete((response, throwable) -> {
                if (Objects.nonNull(throwable)) {
                    measurement.record((Throwable)throwable);
                }
            });
        };
    }

    private MicrometerPlugin(MeterRegistry registry, String metricName, ImmutableList<Tag> defaultTags, TagGenerator generator) {
        this.registry = registry;
        this.metricName = metricName;
        this.defaultTags = defaultTags;
        this.generator = generator;
    }

    private final class Measurement {
        private final Timer.Sample sample;
        private final RequestArguments arguments;

        void record(ClientHttpResponse response) throws IOException {
            this.record(timer -> timer.tags(MicrometerPlugin.this.generator.onResponse(this.arguments, response)));
        }

        void record(Throwable throwable) {
            this.record(timer -> timer.tags(MicrometerPlugin.this.generator.onError(this.arguments, throwable)));
        }

        <X extends Exception> void record(ThrowingUnaryOperator<Timer.Builder, X> build) throws X {
            Timer.Builder builder = (Timer.Builder)build.tryApply((Object)Timer.builder((String)MicrometerPlugin.this.metricName).tags((Iterable)MicrometerPlugin.this.defaultTags).tags(MicrometerPlugin.this.generator.onRequest(this.arguments)));
            Timer timer = builder.register(MicrometerPlugin.this.registry);
            this.sample.stop(timer);
        }

        public Measurement(RequestArguments arguments) {
            this.sample = Timer.start((MeterRegistry)MicrometerPlugin.this.registry);
            this.arguments = arguments;
        }
    }
}

