/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.micrometer;

import com.google.common.collect.ImmutableList;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class ThreadPoolMetrics
implements MeterBinder {
    private final ThreadPoolExecutor executor;
    private final String metricName;
    private final ImmutableList<Tag> defaultTags;

    public ThreadPoolMetrics(ThreadPoolExecutor executor) {
        this(executor, "http.client.threads", (ImmutableList<Tag>)ImmutableList.of());
    }

    public ThreadPoolMetrics withMetricName(String metricName) {
        return new ThreadPoolMetrics(this.executor, metricName, this.defaultTags);
    }

    public ThreadPoolMetrics withDefaultTags(Tag ... defaultTags) {
        return this.withDefaultTags((Iterable<Tag>)ImmutableList.copyOf((Object[])defaultTags));
    }

    public ThreadPoolMetrics withDefaultTags(Iterable<Tag> defaultTags) {
        return new ThreadPoolMetrics(this.executor, this.metricName, (ImmutableList<Tag>)ImmutableList.copyOf(defaultTags));
    }

    public void bindTo(MeterRegistry registry) {
        this.gauge("available", () -> this.executor.getPoolSize() - this.executor.getActiveCount()).description("The number idle threads").baseUnit("threads").register(registry);
        this.gauge("leased", this.executor::getActiveCount).description("The number of threads that are actively executing tasks").baseUnit("threads").register(registry);
        this.gauge("total", this.executor::getPoolSize).description("The number of threads that are currently in the pool").baseUnit("threads").register(registry);
        this.gauge("min", this.executor::getCorePoolSize).description("The minimum number of threads in the pool").baseUnit("threads").register(registry);
        this.gauge("max", this.executor::getMaximumPoolSize).description("The maximum number of threads in the pool").baseUnit("threads").register(registry);
        this.gauge("queued", () -> this.executor.getQueue().size()).description("The number of queued tasks").baseUnit("tasks").register(registry);
    }

    private Gauge.Builder<Supplier<Number>> gauge(String name, Supplier<Number> supplier) {
        return Gauge.builder((String)(this.metricName + "." + name), supplier).tags(this.defaultTags);
    }

    private ThreadPoolMetrics(ThreadPoolExecutor executor, String metricName, ImmutableList<Tag> defaultTags) {
        this.executor = executor;
        this.metricName = metricName;
        this.defaultTags = defaultTags;
    }
}

