/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.micrometer.tag;

import com.google.common.collect.Lists;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.CheckReturnValue;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.micrometer.tag.CompositeTagGenerator;

@API(status=API.Status.EXPERIMENTAL)
public interface TagGenerator {
    @CheckReturnValue
    default public Iterable<Tag> onRequest(RequestArguments arguments) {
        return Collections.emptyList();
    }

    @CheckReturnValue
    default public Iterable<Tag> onResponse(RequestArguments arguments, ClientHttpResponse response) throws IOException {
        return Collections.emptyList();
    }

    @CheckReturnValue
    default public Iterable<Tag> onError(RequestArguments arguments, Throwable throwable) {
        return Collections.emptyList();
    }

    public static TagGenerator composite(TagGenerator generator, TagGenerator ... generators) {
        return TagGenerator.composite(Lists.asList((Object)generator, (Object[])generators));
    }

    public static TagGenerator composite(Iterable<TagGenerator> generators) {
        return new CompositeTagGenerator(generators);
    }
}

