/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.micrometer.tag;

import com.google.common.base.Throwables;
import io.micrometer.core.instrument.Tag;
import java.util.Collections;
import java.util.Set;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.micrometer.tag.TagGenerator;

@API(status=API.Status.EXPERIMENTAL)
public final class ErrorKindTagGenerator
implements TagGenerator {
    private static final String ERROR_KIND = "error.kind";
    private static final Set<Tag> NONE = Collections.singleton(Tag.of((String)"error.kind", (String)"none"));
    private final UnaryOperator<Throwable> extractor;

    public ErrorKindTagGenerator() {
        this(Throwables::getRootCause);
    }

    @Override
    public Iterable<Tag> onResponse(RequestArguments arguments, ClientHttpResponse response) {
        return NONE;
    }

    @Override
    public Iterable<Tag> onError(RequestArguments arguments, Throwable throwable) {
        Throwable error = (Throwable)this.extractor.apply(throwable);
        String name = error.getClass().getSimpleName();
        return Collections.singleton(Tag.of((String)ERROR_KIND, (String)name));
    }

    @Generated
    public ErrorKindTagGenerator(UnaryOperator<Throwable> extractor) {
        this.extractor = extractor;
    }
}

