/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.micrometer.tag;

import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.micrometer.tag.TagGenerator;

@API(status=API.Status.EXPERIMENTAL)
public final class HttpStatusTagGenerator
implements TagGenerator {
    private static final String STATUS_CODE = "http.status_code";
    private static final Set<Tag> NONE = Collections.singleton(Tag.of((String)"http.status_code", (String)"0"));

    @Override
    public Iterable<Tag> onResponse(RequestArguments arguments, ClientHttpResponse response) throws IOException {
        String status = String.valueOf(response.getRawStatusCode());
        return Collections.singleton(Tag.of((String)STATUS_CODE, (String)status));
    }

    @Override
    public Iterable<Tag> onError(RequestArguments arguments, Throwable throwable) {
        return NONE;
    }
}

