/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.opentracing.span;

import com.google.common.collect.Lists;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.opentracing.span.CompositeSpanDecorator;

public interface SpanDecorator {
    default public void onStart(Tracer.SpanBuilder builder, RequestArguments arguments) {
    }

    default public void onStarted(Span span, RequestArguments arguments) {
    }

    default public void onResponse(Span span, RequestArguments arguments, ClientHttpResponse response) throws IOException {
    }

    default public void onError(Span span, RequestArguments arguments, Throwable error) {
    }

    public static SpanDecorator composite(SpanDecorator decorator, SpanDecorator ... decorators) {
        return SpanDecorator.composite(Lists.asList((Object)decorator, (Object[])decorators));
    }

    public static SpanDecorator composite(Collection<SpanDecorator> decorators) {
        return decorators.stream().flatMap(decorator -> decorator instanceof CompositeSpanDecorator ? ((CompositeSpanDecorator)CompositeSpanDecorator.class.cast(decorator)).getDecorators().stream() : Stream.of(decorator)).collect(Collectors.collectingAndThen(Collectors.toList(), CompositeSpanDecorator::new));
    }
}

