/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.opentracing.span;

import com.google.common.collect.ImmutableMap;
import io.opentracing.Span;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.fauxpas.FauxPas;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.opentracing.span.SpanDecorator;

public final class ErrorSpanDecorator
implements SpanDecorator {
    private final Predicate<ClientHttpResponse> predicate;

    public ErrorSpanDecorator() {
        this((Predicate<ClientHttpResponse>)FauxPas.throwingPredicate(response -> response.getStatusCode().is5xxServerError()));
    }

    @Override
    public void onResponse(Span span, RequestArguments arguments, ClientHttpResponse response) throws IOException {
        if (this.predicate.test(response)) {
            span.setTag((Tag)Tags.ERROR, (Object)true);
        }
    }

    @Override
    public void onError(Span span, RequestArguments arguments, Throwable error) {
        span.setTag((Tag)Tags.ERROR, (Object)true);
        span.log((Map)ImmutableMap.of((Object)"error.kind", (Object)error.getClass().getSimpleName(), (Object)"error.object", (Object)error));
    }

    public ErrorSpanDecorator(Predicate<ClientHttpResponse> predicate) {
        this.predicate = predicate;
    }
}

