/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.opentracing.span;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.opentracing.Span;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.zalando.riptide.opentracing.span.HeaderExtractor;
import org.zalando.riptide.opentracing.span.HttpSpanOperator;

final class HttpSpanLogger
implements HttpSpanOperator {
    private final HeaderExtractor extractor = new HeaderExtractor();
    private final Map<String, List<String>> logs;

    @Override
    public void apply(Span span, Map<String, List<String>> headers) {
        HashMap fields = new HashMap();
        this.logs.forEach((log, names) -> this.extractor.extract(headers, (List<String>)names).ifPresent(value -> fields.put(log, value)));
        if (fields.isEmpty()) {
            return;
        }
        span.log(fields);
    }

    static HttpSpanLogger logging(String log, String name, String ... names) {
        return HttpSpanLogger.logging((Map<String, List<String>>)ImmutableMap.of((Object)log, (Object)Lists.asList((Object)name, (Object[])names)));
    }

    static HttpSpanLogger logging(Map<String, List<String>> logs) {
        return new HttpSpanLogger(logs);
    }

    @Generated
    private HttpSpanLogger(Map<String, List<String>> logs) {
        this.logs = logs;
    }
}

