/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.opentracing.span;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.opentracing.Span;
import io.opentracing.tag.Tag;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.zalando.riptide.opentracing.span.HeaderExtractor;
import org.zalando.riptide.opentracing.span.HttpSpanOperator;

final class HttpSpanTagger
implements HttpSpanOperator {
    private final HeaderExtractor extractor = new HeaderExtractor();
    private final Map<Tag<String>, List<String>> tags;

    @Override
    public void apply(Span span, Map<String, List<String>> headers) {
        this.tags.forEach((tag, names) -> this.extractor.extract(headers, (List<String>)names).ifPresent(value -> span.setTag(tag, value)));
    }

    static HttpSpanTagger tagging(Tag<String> tag, String name, String ... names) {
        return HttpSpanTagger.tagging((Map<Tag<String>, List<String>>)ImmutableMap.of(tag, (Object)Lists.asList((Object)name, (Object[])names)));
    }

    static HttpSpanTagger tagging(Map<Tag<String>, List<String>> tags) {
        return new HttpSpanTagger(tags);
    }

    @Generated
    private HttpSpanTagger(Map<Tag<String>, List<String>> tags) {
        this.tags = tags;
    }
}

