/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.opentracing.span;

import io.opentracing.Span;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.net.URI;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.opentracing.ExtensionTags;
import org.zalando.riptide.opentracing.span.SpanDecorator;

public final class PeerSpanDecorator
implements SpanDecorator {
    @Override
    public void onRequest(Span span, RequestArguments arguments) {
        URI uri = arguments.getRequestUri();
        int port = uri.getPort();
        span.setTag((Tag)Tags.PEER_HOSTNAME, (Object)uri.getHost());
        if (port == -1) {
            span.setTag(ExtensionTags.PEER_ADDRESS, (Object)uri.getHost());
        } else {
            span.setTag(ExtensionTags.PEER_ADDRESS, (Object)(uri.getHost() + ":" + port));
            span.setTag((Tag)Tags.PEER_PORT, (Object)port);
        }
    }
}

