/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.opentracing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Multimaps;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import javax.annotation.CheckReturnValue;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.fauxpas.ThrowingBiConsumer;
import org.zalando.riptide.Attribute;
import org.zalando.riptide.Plugin;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.opentracing.span.CallSiteSpanDecorator;
import org.zalando.riptide.opentracing.span.ComponentSpanDecorator;
import org.zalando.riptide.opentracing.span.ErrorSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpMethodSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpPathSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpStatusCodeSpanDecorator;
import org.zalando.riptide.opentracing.span.PeerSpanDecorator;
import org.zalando.riptide.opentracing.span.SpanDecorator;
import org.zalando.riptide.opentracing.span.SpanKindSpanDecorator;

public final class OpenTracingPlugin
implements Plugin {
    public static final Attribute<String> OPERATION_NAME = Attribute.generate();
    public static final Attribute<Map<String, String>> TAGS = Attribute.generate();
    public static final Attribute<Map<String, Object>> LOGS = Attribute.generate();
    private final Tracer tracer;
    private final SpanDecorator decorator;

    public OpenTracingPlugin(Tracer tracer) {
        this(tracer, SpanDecorator.composite(new CallSiteSpanDecorator(), new ComponentSpanDecorator(), new ErrorSpanDecorator(), new HttpMethodSpanDecorator(), new HttpPathSpanDecorator(), new HttpStatusCodeSpanDecorator(), new PeerSpanDecorator(), new SpanKindSpanDecorator()));
    }

    @CheckReturnValue
    public OpenTracingPlugin withAdditionalSpanDecorators(SpanDecorator first, SpanDecorator ... decorators) {
        return this.withSpanDecorators(this.decorator, SpanDecorator.composite(first, decorators));
    }

    @CheckReturnValue
    public OpenTracingPlugin withSpanDecorators(SpanDecorator decorator, SpanDecorator ... decorators) {
        return new OpenTracingPlugin(this.tracer, SpanDecorator.composite(decorator, decorators));
    }

    public RequestExecution aroundDispatch(RequestExecution execution) {
        return arguments -> {
            Span span = this.startSpan(arguments);
            Scope scope = this.tracer.activateSpan(span);
            return ((CompletableFuture)execution.execute(arguments).whenComplete(OpenTracingPlugin.perform(() -> ((Scope)scope).close()))).whenComplete(OpenTracingPlugin.perform(() -> ((Span)span).finish()));
        };
    }

    public RequestExecution aroundNetwork(RequestExecution execution) {
        return arguments -> {
            Span span = this.tracer.activeSpan();
            return ((CompletableFuture)execution.execute(this.inject(arguments, span.context())).whenComplete((BiConsumer)this.onResponse(span, arguments))).whenComplete(this.onError(span, arguments));
        };
    }

    private Span startSpan(RequestArguments arguments) {
        String operationName = arguments.getAttribute(OPERATION_NAME).orElse(arguments.getMethod().name());
        Tracer.SpanBuilder builder = this.tracer.buildSpan(operationName);
        this.decorator.onStart(builder, arguments);
        Span span = builder.start();
        this.decorator.onStarted(span, arguments);
        return span;
    }

    private RequestArguments inject(RequestArguments arguments, SpanContext context) {
        HashMap headers = new HashMap();
        this.tracer.inject(context, Format.Builtin.HTTP_HEADERS, (Object)new TextMapAdapter(headers));
        return arguments.withHeaders(Multimaps.forMap(headers).asMap());
    }

    private ThrowingBiConsumer<ClientHttpResponse, Throwable, IOException> onResponse(Span span, RequestArguments arguments) {
        return (response, error) -> {
            if (Objects.nonNull(response)) {
                this.decorator.onResponse(span, arguments, (ClientHttpResponse)response);
            }
        };
    }

    private BiConsumer<ClientHttpResponse, Throwable> onError(Span span, RequestArguments arguments) {
        return (response, error) -> {
            if (Objects.nonNull(error)) {
                this.decorator.onError(span, arguments, OpenTracingPlugin.unpack(error));
            }
        };
    }

    private static <T, U> BiConsumer<T, U> perform(Runnable runnable) {
        return (t, u) -> runnable.run();
    }

    @VisibleForTesting
    static Throwable unpack(Throwable error) {
        return error instanceof CompletionException ? error.getCause() : error;
    }

    private OpenTracingPlugin(Tracer tracer, SpanDecorator decorator) {
        this.tracer = tracer;
        this.decorator = decorator;
    }
}

