/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.opentracing.span;

import io.opentracing.Span;
import java.util.Collection;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.fauxpas.FauxPas;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.opentracing.span.SpanDecorator;

final class CompositeSpanDecorator
implements SpanDecorator {
    private final Collection<SpanDecorator> decorators;

    CompositeSpanDecorator(Collection<SpanDecorator> decorators) {
        this.decorators = decorators;
    }

    @Override
    public void onRequest(Span span, RequestArguments arguments) {
        this.decorators.forEach(decorator -> decorator.onRequest(span, arguments));
    }

    @Override
    public void onResponse(Span span, RequestArguments arguments, ClientHttpResponse response) {
        this.decorators.forEach(FauxPas.throwingConsumer(decorator -> decorator.onResponse(span, arguments, response)));
    }

    @Override
    public void onError(Span span, RequestArguments arguments, Throwable error) {
        this.decorators.forEach(decorator -> decorator.onError(span, arguments, error));
    }

    public Collection<SpanDecorator> getDecorators() {
        return this.decorators;
    }
}

