/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.opentracing;

import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.opentracing.ForwardingSpan;
import org.zalando.riptide.opentracing.LifecyclePolicy;

final class CompositeLifecyclePolicy
implements LifecyclePolicy {
    private final Collection<LifecyclePolicy> policies;

    @Override
    public Optional<Span> start(Tracer tracer, RequestArguments arguments) {
        for (LifecyclePolicy policy : this.policies) {
            Optional<Span> span = policy.start(tracer, arguments);
            if (!span.isPresent()) continue;
            return Optional.of(new FinishingSpan(span.get(), policy::finish));
        }
        return Optional.empty();
    }

    @Override
    public void finish(Span span) {
        span.finish();
    }

    public CompositeLifecyclePolicy(Collection<LifecyclePolicy> policies) {
        this.policies = policies;
    }

    private static final class FinishingSpan
    extends ForwardingSpan {
        private final Span span;
        private final Consumer<Span> callback;

        @Override
        protected Span delegate() {
            return this.span;
        }

        @Override
        public void finish() {
            this.callback.accept(this.span);
        }

        public FinishingSpan(Span span, Consumer<Span> callback) {
            this.span = span;
            this.callback = callback;
        }
    }
}

