/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.opentracing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Multimaps;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.fauxpas.ThrowingBiConsumer;
import org.zalando.riptide.Attribute;
import org.zalando.riptide.Plugin;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.opentracing.ActivationPolicy;
import org.zalando.riptide.opentracing.DefaultActivationPolicy;
import org.zalando.riptide.opentracing.ExplicitSpanLifecyclePolicy;
import org.zalando.riptide.opentracing.LifecyclePolicy;
import org.zalando.riptide.opentracing.NewSpanLifecyclePolicy;
import org.zalando.riptide.opentracing.span.CallSiteSpanDecorator;
import org.zalando.riptide.opentracing.span.ComponentSpanDecorator;
import org.zalando.riptide.opentracing.span.CompositeSpanDecorator;
import org.zalando.riptide.opentracing.span.ErrorSpanDecorator;
import org.zalando.riptide.opentracing.span.ErrorStackSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpContentLanguageSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpContentLengthSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpMethodOverrideSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpMethodSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpPathSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpPreferSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpRetryAfterSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpStatusCodeSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpWarningSpanDecorator;
import org.zalando.riptide.opentracing.span.PeerSpanDecorator;
import org.zalando.riptide.opentracing.span.RateLimitSpanDecorator;
import org.zalando.riptide.opentracing.span.ServiceLoaderSpanDecorator;
import org.zalando.riptide.opentracing.span.SpanDecorator;
import org.zalando.riptide.opentracing.span.SpanKindSpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class OpenTracingPlugin
implements Plugin {
    public static final Attribute<Span> SPAN = Attribute.generate();
    public static final Attribute<String> OPERATION_NAME = Attribute.generate();
    public static final Attribute<Map<String, String>> TAGS = Attribute.generate();
    public static final Attribute<Map<String, Object>> LOGS = Attribute.generate();
    private static final Attribute<Span> INTERNAL_SPAN = Attribute.generate();
    private final Tracer tracer;
    private final LifecyclePolicy lifecyclePolicy;
    private final ActivationPolicy activationPolicy;
    private final SpanDecorator decorator;

    public OpenTracingPlugin(Tracer tracer) {
        this(tracer, LifecyclePolicy.composite(new ExplicitSpanLifecyclePolicy(), new NewSpanLifecyclePolicy()), new DefaultActivationPolicy(), CompositeSpanDecorator.composite(new CallSiteSpanDecorator(), new ComponentSpanDecorator(), new ErrorSpanDecorator(), new ErrorStackSpanDecorator(), new HttpContentLengthSpanDecorator(), new HttpContentLanguageSpanDecorator(), new HttpMethodOverrideSpanDecorator(), new HttpMethodSpanDecorator(), new HttpPathSpanDecorator(), new HttpPreferSpanDecorator(), new HttpRetryAfterSpanDecorator(), new HttpStatusCodeSpanDecorator(), new HttpWarningSpanDecorator(), new PeerSpanDecorator(), new RateLimitSpanDecorator(), new ServiceLoaderSpanDecorator(), new SpanKindSpanDecorator()));
    }

    @CheckReturnValue
    public OpenTracingPlugin withLifecyclePolicy(LifecyclePolicy lifecyclePolicy) {
        return new OpenTracingPlugin(this.tracer, lifecyclePolicy, this.activationPolicy, this.decorator);
    }

    @CheckReturnValue
    public OpenTracingPlugin withActivationPolicy(ActivationPolicy activationPolicy) {
        return new OpenTracingPlugin(this.tracer, this.lifecyclePolicy, activationPolicy, this.decorator);
    }

    @CheckReturnValue
    public OpenTracingPlugin withAdditionalSpanDecorators(SpanDecorator first, SpanDecorator ... decorators) {
        return this.withSpanDecorators(this.decorator, CompositeSpanDecorator.composite(first, decorators));
    }

    @CheckReturnValue
    public OpenTracingPlugin withSpanDecorators(SpanDecorator decorator, SpanDecorator ... decorators) {
        return new OpenTracingPlugin(this.tracer, this.lifecyclePolicy, this.activationPolicy, CompositeSpanDecorator.composite(decorator, decorators));
    }

    public RequestExecution aroundDispatch(RequestExecution execution) {
        return arguments -> {
            Span span = this.lifecyclePolicy.start(this.tracer, arguments).orElse(null);
            if (span == null) {
                return execution.execute(arguments);
            }
            Runnable close = this.activationPolicy.activate(this.tracer, span);
            Runnable finish = () -> this.lifecyclePolicy.finish(span);
            return execution.execute(arguments.withAttribute(INTERNAL_SPAN, (Object)span)).whenComplete(OpenTracingPlugin.perform(close, finish));
        };
    }

    public RequestExecution aroundNetwork(RequestExecution execution) {
        return arguments -> {
            Span span = arguments.getAttribute(INTERNAL_SPAN).orElse(null);
            if (span == null) {
                return execution.execute(arguments);
            }
            this.decorator.onRequest(span, arguments);
            return execution.execute(this.inject(arguments, span.context())).whenComplete((BiConsumer)this.decorate(span, arguments));
        };
    }

    private RequestArguments inject(RequestArguments arguments, SpanContext context) {
        HashMap headers = new HashMap();
        this.tracer.inject(context, Format.Builtin.HTTP_HEADERS, (Object)new TextMapAdapter(headers));
        return arguments.withHeaders(Multimaps.forMap(headers).asMap());
    }

    private ThrowingBiConsumer<ClientHttpResponse, Throwable, IOException> decorate(Span span, RequestArguments arguments) {
        return (response, error) -> {
            if (Objects.nonNull(response)) {
                this.decorator.onResponse(span, arguments, (ClientHttpResponse)response);
            }
            if (Objects.nonNull(error)) {
                this.decorator.onError(span, arguments, OpenTracingPlugin.unpack(error));
            }
        };
    }

    private static <T, U> BiConsumer<T, U> perform(Runnable ... runnables) {
        return (t, u) -> Stream.of(runnables).forEach(Runnable::run);
    }

    @VisibleForTesting
    static Throwable unpack(Throwable error) {
        return error instanceof CompletionException ? error.getCause() : error;
    }

    private OpenTracingPlugin(Tracer tracer, LifecyclePolicy lifecyclePolicy, ActivationPolicy activationPolicy, SpanDecorator decorator) {
        this.tracer = tracer;
        this.lifecyclePolicy = lifecyclePolicy;
        this.activationPolicy = activationPolicy;
        this.decorator = decorator;
    }
}

