/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.opentracing.span;

import com.google.common.collect.Lists;
import io.opentracing.Span;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.fauxpas.FauxPas;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.opentracing.span.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class CompositeSpanDecorator
implements SpanDecorator {
    private final Iterable<SpanDecorator> decorators;

    @Override
    public void onRequest(Span span, RequestArguments arguments) {
        this.decorators.forEach(decorator -> decorator.onRequest(span, arguments));
    }

    @Override
    public void onResponse(Span span, RequestArguments arguments, ClientHttpResponse response) {
        this.decorators.forEach((Consumer<SpanDecorator>)FauxPas.throwingConsumer(decorator -> decorator.onResponse(span, arguments, response)));
    }

    @Override
    public void onError(Span span, RequestArguments arguments, Throwable error) {
        this.decorators.forEach(decorator -> decorator.onError(span, arguments, error));
    }

    public static SpanDecorator composite(SpanDecorator decorator, SpanDecorator ... decorators) {
        return CompositeSpanDecorator.composite(Lists.asList((Object)decorator, (Object[])decorators));
    }

    public static SpanDecorator composite(Iterable<SpanDecorator> decorators) {
        return new CompositeSpanDecorator(decorators);
    }

    private CompositeSpanDecorator(Iterable<SpanDecorator> decorators) {
        this.decorators = decorators;
    }
}

