/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.opentracing.span;

import com.google.common.collect.ImmutableMap;
import com.google.gag.annotation.remark.Hack;
import io.opentracing.Span;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.web.util.UriComponentsBuilder;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.opentracing.span.SpanDecorator;

public final class UriVariablesTagSpanDecorator
implements SpanDecorator {
    @Override
    public void onRequest(Span span, RequestArguments arguments) {
        Map<String, String> variables = this.extract(arguments);
        variables.forEach((arg_0, arg_1) -> ((Span)span).setTag(arg_0, arg_1));
    }

    private Map<String, String> extract(RequestArguments arguments) {
        String template = arguments.getUriTemplate();
        if (template == null) {
            return ImmutableMap.of();
        }
        return this.extract(template, arguments.getUriVariables());
    }

    @Hack(value="Pretty dirty, but I couldn't find any other way...")
    private Map<String, String> extract(String template, List<Object> values) {
        HashMap<String, String> variables = new HashMap<String, String>(values.size());
        Iterator<Object> iterator = values.iterator();
        UriComponentsBuilder.fromUriString((String)template).build().expand(name -> {
            Object value = iterator.next();
            variables.put(name, String.valueOf(value));
            return value;
        });
        return variables;
    }
}

