/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.opentracing;

import com.google.common.annotations.VisibleForTesting;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import javax.annotation.CheckReturnValue;
import lombok.Generated;
import org.apiguardian.api.API;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.fauxpas.ThrowingBiConsumer;
import org.zalando.riptide.Attribute;
import org.zalando.riptide.Plugin;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.RequestExecution;
import org.zalando.riptide.opentracing.Activation;
import org.zalando.riptide.opentracing.DefaultActivation;
import org.zalando.riptide.opentracing.DefaultInjection;
import org.zalando.riptide.opentracing.ExplicitSpanLifecycle;
import org.zalando.riptide.opentracing.Injection;
import org.zalando.riptide.opentracing.Lifecycle;
import org.zalando.riptide.opentracing.NewSpanLifecycle;
import org.zalando.riptide.opentracing.span.CallSiteSpanDecorator;
import org.zalando.riptide.opentracing.span.ComponentSpanDecorator;
import org.zalando.riptide.opentracing.span.CompositeSpanDecorator;
import org.zalando.riptide.opentracing.span.ErrorSpanDecorator;
import org.zalando.riptide.opentracing.span.ErrorStackSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpMethodOverrideSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpMethodSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpPathSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpPreferSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpRetryAfterSpanDecorator;
import org.zalando.riptide.opentracing.span.HttpStatusCodeSpanDecorator;
import org.zalando.riptide.opentracing.span.PeerSpanDecorator;
import org.zalando.riptide.opentracing.span.ServiceLoaderSpanDecorator;
import org.zalando.riptide.opentracing.span.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class OpenTracingPlugin
implements Plugin {
    public static final Attribute<Span> SPAN = Attribute.generate();
    public static final Attribute<String> OPERATION_NAME = Attribute.generate();
    public static final Attribute<Map<String, String>> TAGS = Attribute.generate();
    public static final Attribute<Map<String, Object>> LOGS = Attribute.generate();
    private final Attribute<Span> internalSpan = Attribute.generate();
    private final Tracer tracer;
    private final Lifecycle lifecycle;
    private final Activation activation;
    private final Injection injection;
    private final SpanDecorator decorator;

    public OpenTracingPlugin(Tracer tracer) {
        this(tracer, Lifecycle.composite(new ExplicitSpanLifecycle(), new NewSpanLifecycle()), new DefaultActivation(), new DefaultInjection(), CompositeSpanDecorator.composite(new CallSiteSpanDecorator(), new ComponentSpanDecorator(), new ErrorSpanDecorator(), new ErrorStackSpanDecorator(), new HttpMethodOverrideSpanDecorator(), new HttpMethodSpanDecorator(), new HttpPathSpanDecorator(), new HttpPreferSpanDecorator(), new HttpRetryAfterSpanDecorator(), new HttpStatusCodeSpanDecorator(), new PeerSpanDecorator(), new ServiceLoaderSpanDecorator()));
    }

    @CheckReturnValue
    public OpenTracingPlugin withLifecycle(Lifecycle lifecycle) {
        return new OpenTracingPlugin(this.tracer, lifecycle, this.activation, this.injection, this.decorator);
    }

    @CheckReturnValue
    public OpenTracingPlugin withActivation(Activation activation) {
        return new OpenTracingPlugin(this.tracer, this.lifecycle, activation, this.injection, this.decorator);
    }

    @CheckReturnValue
    public OpenTracingPlugin withInjection(Injection injection) {
        return new OpenTracingPlugin(this.tracer, this.lifecycle, this.activation, injection, this.decorator);
    }

    @CheckReturnValue
    public OpenTracingPlugin withAdditionalSpanDecorators(SpanDecorator first, SpanDecorator ... decorators) {
        return this.withSpanDecorators(this.decorator, CompositeSpanDecorator.composite(first, decorators));
    }

    @CheckReturnValue
    public OpenTracingPlugin withSpanDecorators(SpanDecorator decorator, SpanDecorator ... decorators) {
        return new OpenTracingPlugin(this.tracer, this.lifecycle, this.activation, this.injection, CompositeSpanDecorator.composite(decorator, decorators));
    }

    public RequestExecution aroundDispatch(RequestExecution execution) {
        return arguments -> this.trace(execution, arguments);
    }

    private CompletableFuture<ClientHttpResponse> trace(RequestExecution execution, RequestArguments arguments) throws IOException {
        Span span = this.lifecycle.start(this.tracer, arguments).orElse(null);
        if (span == null) {
            return execution.execute(arguments);
        }
        Scope scope = this.activation.activate(this.tracer, span);
        return ((CompletableFuture)execution.execute(arguments.withAttribute(this.internalSpan, (Object)span)).whenComplete(this.run(() -> ((Scope)scope).close()))).whenComplete(this.run(() -> ((Span)span).finish()));
    }

    private <T, U> BiConsumer<T, U> run(Runnable runnable) {
        return (t, U) -> runnable.run();
    }

    public RequestExecution aroundNetwork(RequestExecution execution) {
        return arguments -> this.inject(execution, arguments);
    }

    private CompletableFuture<ClientHttpResponse> inject(RequestExecution execution, RequestArguments arguments) throws IOException {
        Span span = arguments.getAttribute(this.internalSpan).orElse(null);
        if (span == null) {
            return execution.execute(arguments);
        }
        this.decorator.onRequest(span, arguments);
        SpanContext context = span.context();
        return ((CompletableFuture)execution.execute(this.injection.inject(this.tracer, arguments, context)).whenComplete((BiConsumer)this.decorateOnResponse(span, arguments))).whenComplete(this.decorateOnError(span, arguments));
    }

    private ThrowingBiConsumer<ClientHttpResponse, Throwable, IOException> decorateOnResponse(Span span, RequestArguments arguments) {
        return (response, error) -> {
            if (Objects.nonNull(response)) {
                this.decorator.onResponse(span, arguments, (ClientHttpResponse)response);
            }
        };
    }

    private BiConsumer<ClientHttpResponse, Throwable> decorateOnError(Span span, RequestArguments arguments) {
        return (response, error) -> {
            if (Objects.nonNull(error)) {
                this.decorator.onError(span, arguments, OpenTracingPlugin.unpack(error));
            }
        };
    }

    @VisibleForTesting
    static Throwable unpack(Throwable error) {
        return error instanceof CompletionException ? error.getCause() : error;
    }

    @Generated
    private OpenTracingPlugin(Tracer tracer, Lifecycle lifecycle, Activation activation, Injection injection, SpanDecorator decorator) {
        this.tracer = tracer;
        this.lifecycle = lifecycle;
        this.activation = activation;
        this.injection = injection;
        this.decorator = decorator;
    }
}

