/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.opentracing.span;

import com.google.common.annotations.VisibleForTesting;
import io.opentracing.Span;
import java.util.Collections;
import org.zalando.riptide.OriginalStackTracePlugin;
import org.zalando.riptide.RequestArguments;
import org.zalando.riptide.opentracing.span.SpanDecorator;

public final class ErrorStackSpanDecorator
implements SpanDecorator {
    private final StackRenderer renderer = new StackRenderer();

    @Override
    public void onError(Span span, RequestArguments arguments, Throwable error) {
        String stack = arguments.getAttribute(OriginalStackTracePlugin.STACK).map(original -> this.renderer.render(error, (StackTraceElement[])original.get())).orElseGet(() -> this.renderer.render(error));
        span.log(Collections.singletonMap("stack", stack));
    }

    @VisibleForTesting
    static final class StackRenderer {
        private final StackTraceElement[] empty = new StackTraceElement[0];

        StackRenderer() {
        }

        String render(Throwable throwable) {
            return this.render(throwable, this.empty);
        }

        String render(Throwable throwable, StackTraceElement[] original) {
            StringBuilder output = new StringBuilder(2048);
            this.printStackTrace(throwable, original, output);
            return output.toString();
        }

        private void printStackTrace(Throwable throwable, StringBuilder output) {
            this.printStackTrace(throwable, this.empty, output);
        }

        private void printStackTrace(Throwable throwable, StackTraceElement[] original, StringBuilder output) {
            output.append(throwable).append("\n");
            this.print(throwable.getStackTrace(), output);
            this.print(original, output);
            Throwable cause = throwable.getCause();
            if (cause != null) {
                output.append("Caused by: ");
                this.printStackTrace(cause, output);
            }
        }

        private void print(StackTraceElement[] elements, StringBuilder output) {
            for (StackTraceElement element : elements) {
                output.append("\tat ").append(element.toString()).append("\n");
            }
        }
    }
}

